require( "HiddenObject/Script/style.lua" );
DebugOut("ChoosePlayer");
function ShowSubmitOptions( show )
	EnableWindow( "delete", show )
	EnableWindow( "chooseok", show )
	EnableWindow( "editname", show )
end

function ShowCreateOptions( show )
	EnableWindow( "newplayer", show )
end

function UpdatePlayerChoices( curUser, numUsers, userTable )

	if (numUsers >= kMaxUsers) then
		ShowCreateOptions(false)
	else
		ShowCreateOptions(true)
	end

	if (numUsers==0) then
		ShowSubmitOptions( false )
	else
		ShowSubmitOptions( true )
	end

	for i = 0,numUsers-1 do
		SetLabel( "button"..i, userTable[ i+1 ] );
		EnableWindow( "button"..i, true ) ;
	end

	for i = numUsers, kMaxUsers do
		EnableWindow( "button"..i, false ) ;
	end

	if numUsers>0 then
		SetButtonToggleState( "button"..curUser, true );
	end

	DebugOut("UpdatePlayerChoices");
end

NameFont = {
  standardFont,
  24,
  WhiteColor
};

HeaderFont = {
  standardFont,
  36,
  Color(131, 167, 184, 255),
};

NameTextFont = {
  standardFont,
  20,
  Color(204, 198, 183, 255)
};

ChoosePlayerButtonFont = {
  standardFont,
  18,
  Color(131, 167, 184, 255)
};

ButtonX = kCenter;
ButtonY = 60;
ButtonYSpace = 26;

kMaxUsers = 10

NameButtonGraphics = {
	"",
	"HiddenObject/UI/Button/choosenamedown.png",
	"HiddenObject/UI/Button/choosenameover.png",
};	

NameStyle= {
	type = kRadio,
	flags = kHAlignCenter + kVAlignCenter,
	font = NameTextFont,
	graphics = NameButtonGraphics,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonOverSound,
};


LeftGraphics = {
	"HiddenObject/UI/Button/leftnormal.png",
	"HiddenObject/UI/Button/leftdown.png",
	"HiddenObject/UI/Button/leftover.png",
};	

LeftStyle= {
	type = kPush,
	flags = kHAlignCenter + kVAlignCenter,
	font = ButtonFont,
	graphics = LeftGraphics,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonOverSound,
};

RightGraphics = {
	"HiddenObject/UI/Button/rightnormal.png",
	"HiddenObject/UI/Button/rightdown.png",
	"HiddenObject/UI/Button/rightover.png",
};	

RightStyle= {
	type = kPush,
	flags = kHAlignCenter + kVAlignCenter,
	font = ButtonFont,
	graphics = RightGraphics,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonOverSound,
};

RectGraphics = {
	"HiddenObject/UI/Button/rectnormal.png",
	"HiddenObject/UI/Button/rectdown.png",
	"HiddenObject/UI/Button/rectover.png",
};	

RectStyle= {
	type = kPush,
	flags = kHAlignCenter + kVAlignCenter,
	font = ButtonFont,
	graphics = RectGraphics,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonOverSound,
};


OkGraphics = {
	"HiddenObject/UI/Button/oknormal.png",
	"HiddenObject/UI/Button/okdown.png",
	"HiddenObject/UI/Button/okover.png",
};	

OkStyle= {
	type = kPush,
	flags = kHAlignCenter + kVAlignCenter,
	font = ButtonFont,
	graphics = OkGraphics,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonOverSound,
};
--gSelected = -1 ;

function AddButtons( N )

	t = { SetStyle(NameStyle), BeginGroup() };

	for i = 0,N-1 do
		table.insert(t,
			Button{
				name="button"..i,
--				command=function() gSelected = i; end,
				label="#name",
				x=ButtonX,
				y=ButtonY+(ButtonYSpace*i),
				font = NameTextFont,
			}
		);	
	end

	return Group(t);
end

MakeDialog
{
	-- Name the modal dialog
	name="chooseplayer",
	Bitmap
	{ 
		image="HiddenObject/UI/Background/choseplayerdialog",
		x=330,
		y=100,
		
		ChoosePlayerWindow
		{
			x = 0, y = 5, w=kMax, h=kMax,
			
			Text
			{
				font = HeaderFont,
				name = "selectaplayer",
				x=0,y=8,w=kMax,h=kMax,
				flags = kHAlignCenter + kVAlignTop,
				label = "selectaplayer"
			};
			
			AddButtons( kMaxUsers );
			
			SetStyle(LeftStyle);				
			Button
			{
				x=25,
				y=325,
				name="editname",
				font = ChoosePlayerButtonFont,
				label="",
				type = kPush,
				label="editname",
				command =
					function()
						gEnterNameValue = GetSelectedPlayerName();
						gTitleName = "editname";
						name = DoModal("HiddenObject/script/entername.lua");
						if (not(name == nil)) then
							SetCurrentUser(GetCurrentSelectedUser());
							ChangeCurrentUserName(name);
							SetPlayerChoices();
							SetWelcomeName();
						end
					end
			};

			SetStyle(OkStyle);
			Button
			{
				x=kCenter,
				y=370,
				name="chooseok",
				font = StandardButtonFont,
				label="ok",
				type = kPush,
				default = true,
				command = 
					function()
						SetCurrentUser(GetCurrentSelectedUser());
						SetWelcomeName();
						PopModal("chooseplayer");
					end
				
			};
				
			SetStyle(RectStyle);
			Button
			{
				x=145,
				y=325,
				name="newplayer",
				label="newplayer",
				font = ChoosePlayerButtonFont,
				type = kPush,
				command =
					function()
						gEnterNameValue = "entername";
						gTitleName = "entername";
						name = DoModal("HiddenObject/script/entername.lua");
						if (not(name == nil)) then
							CreateNewUser(name);
							SetPlayerChoices()
						end
					end
			};
				
			SetStyle(RightStyle);
			Button
			{
				x=275,
				y=325,
				name="delete",
				label="deleteplayer",
				font = ChoosePlayerButtonFont,
				type = kPush,
				command =
					function()
						result = DisplayDialog { 
							"HiddenObject/script/deleteyesno.lua", 
							body ="deleteconfirm",
							title = "deletetitle" 
						};
						if (result=='yes') then
							DeleteUser(GetCurrentSelectedUser())
							SetPlayerChoices()
						end
					end
				
			};
		}
	}
}


--UpdatePlayerChoices( 0,0, {} );

--SetPlayerChoices();

